<?php

/**
 * @file
 * Contains share.page.inc.
 *
 * Page callback for Share entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Share templates.
 *
 * Default template: share.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_share(array &$variables) {
  // Fetch Share Entity Object.
  $share = $variables['elements']['#share'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
