<?php

/**
 * @file
 * Contains share_issue.page.inc.
 *
 * Page callback for Share issue entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Share issue templates.
 *
 * Default template: share_issue.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_share_issue(array &$variables) {
  // Fetch ShareIssue Entity Object.
  $share_issue = $variables['elements']['#share_issue'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
