<?php

/**
 * @file
 * Contains share_transaction.page.inc.
 *
 * Page callback for Share transaction entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Share transaction templates.
 *
 * Default template: share_transaction.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_share_transaction(array &$variables) {
  // Fetch ShareTransaction Entity Object.
  $share_transaction = $variables['elements']['#share_transaction'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
