<?php

/**
 * @file
 * Contains share_transaction_group.page.inc.
 *
 * Page callback for Share Transaction Group entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Share Transaction Group templates.
 *
 * Default template: share_transaction_group.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_share_transaction_group(array &$variables) {
  // Fetch ShareTransactionGroup Entity Object.
  $share_transaction_group = $variables['elements']['#share_transaction_group'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
