<?php

/**
 * @file
 * Contains share_type.page.inc.
 *
 * Page callback for Share type entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Share type templates.
 *
 * Default template: share_type.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_share_type(array &$variables) {
  // Fetch ShareType Entity Object.
  $share_type = $variables['elements']['#share_type'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
