<?php

/**
 * @file
 * Contains shareholder.page.inc.
 *
 * Page callback for Shareholder entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Shareholder templates.
 *
 * Default template: shareholder.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_shareholder(array &$variables) {
  // Fetch Shareholder Entity Object.
  $shareholder = $variables['elements']['#shareholder'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
