<?php

/**
 * Implements hook_drush_command().
 */
function shareholder_register_drush_command() {

  $commands['update-identifiers'] = [
    'description' => 'This command will update (recompute) the shareholder identifiers.',
    'aliases' => ['sr-ui'],
    'arguments' => [],
    'options' => [],
    'examples' => [],
  ];

  $commands['update-shareholder'] = [
    'description' => 'This command will update a shareholder.',
    'aliases' => ['sr-us'],
    'arguments' => [
      'id' => 'shareholder id',
    ],
    'options' => [],
    'examples' => [],
  ];

  $commands['shareholder-certificates'] = [
    'description' => 'This command will export the certificates.',
    'aliases' => ['sr-cert'],
    'arguments' => [],
    'options' => [],
    'examples' => [],
  ];

  $commands['validate-transaction'] = [
    'description' => 'This command will validate a single transaction from the register.',
    'aliases' => [],
    'arguments' => [
      'id' => 'transaction id',
      'skip-issue' => 'skip issuing of shares (for large transactions)',
    ],
    'options' => [],
    'examples' => [],
  ];

  $commands['cancel-validated-transaction'] = [
    'description' => 'This command will delete a single transaction from the register.',
    'aliases' => [],
    'arguments' => [],
    'options' => [],
    'examples' => [],
  ];

  $commands['issue-shares-for-transactions'] = [
    'description' => 'This command will issue shares for all validated transactions.',
    'aliases' => [],
    'arguments' => [
    ],
    'options' => [],
    'examples' => [],
  ];

  $commands['integrity-check'] = [
    'description' => 'This command will perform an integrity check for the register.',
    'aliases' => [],
    'arguments' => [],
    'options' => [],
    'examples' => [],
  ];

  return $commands;
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_update_identifiers() {
  \Drupal::service('shareholder_register.drush')
    ->updateIdentifiers();
}


/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_update_shareholder($id = -1) {
  \Drupal::service('shareholder_register.drush')
    ->updateShareholder($id);
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_shareholder_certificates() {
  \Drupal::service('shareholder_register.drush')
    ->exportCertificates();
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_validate_transaction($id, $skip = FALSE) {
  \Drupal::service('shareholder_register.drush')
    ->validateTransaction($id, $skip);
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_cancel_validated_transaction($id) {
  \Drupal::service('shareholder_register.drush')
    ->cancelValidatedTransaction($id);
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_issue_shares_for_transactions() {
  \Drupal::service('shareholder_register.drush')
    ->issueSharesForTransactions();
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_shareholder_register_integrity_check() {
  \Drupal::service('shareholder_register.drush')
    ->integrityCheck();
}

// @codingStandardsIgnoreStart
/**
 * Class ConfigSplitDrush8Io.
 *
 * This is a stand in for \Symfony\Component\Console\Style\StyleInterface with
 * drush 8 so that we don't need to depend on symfony components.
 */
class ConfigSplitDrush8Io {

  public function confirm($text) {
    return drush_confirm($text);
  }

  public function success($text) {
    drush_log($text, LogLevel::SUCCESS);
  }

  public function error($text) {
    drush_log($text, LogLevel::ERROR);
  }

  public function text($text) {
    drush_log($text, LogLevel::NOTICE);
  }
}
// @codingStandardsIgnoreEnd
