<?php

/**
 * @file
 * Contains shareholder_register\shareholder_register.views.inc.
 *
 * Provide a custom views field data that isn't tied to any other module.
 */

/**
 * Implements hook_views_data().
 */
function shareholder_register_views_data() {

  $data['share_transaction']['share_numbers_field'] = [
    'title' => t('Share numbers field'),
    'help' => t('Summarizes the share numbers attached to the entity.'),
    'field' => [
      'id' => 'share_numbers_field',
    ],
  ];

  $data['shareholder']['share_numbers_field'] = [
    'title' => t('Share numbers field'),
    'help' => t('Summarizes the share numbers attached to the entity.'),
    'field' => [
      'id' => 'share_numbers_field',
    ],
  ];

  $data['share_transaction_group']['single_share_transaction_relationship'] = [
    'title' => t('Single Share Transaction'),
    'help' => t('Provide the single share tansaction for groups with exactly one transaction.'),
    'relationship' => [
      'label' => t('Single Share Transaction'),
      'id' => 'standard',
      'group' => t('Share Transaction Group'),
      'base' => 'share_transaction',
      'base field' => 'transaction_group',
      'field' => 'id',
      'extra' => [
        0 => [
          'left_field' => 'type',
          'value' => ['issue', 'repurchase'],
          'operator' => 'IN',
          'numeric' => TRUE,
        ],
      ],
    ],
  ];

  return $data;
}
