<?php

namespace Drupal\shareholder_register\Commands;

use Drush\Commands\DrushCommands;

/**
 * A Drush commandfile.
 *
 * In addition to this file, you need a drush.services.yml
 * in root of your module, and a composer.json file that provides the name
 * of the services file to use.
 *
 * See these files for an example of injecting Drupal services:
 *   - http://cgit.drupalcode.org/devel/tree/src/Commands/DevelCommands.php
 *   - http://cgit.drupalcode.org/devel/tree/drush.services.yml
 */
class ShareholderRegisterCommands extends DrushCommands {

  /**
   * This command will update (recompute) the shareholder identifiers.
   *
   * @command shareholder:update-identifiers
   * @aliases sr-ui,update-identifiers
   */
  public function updateIdentifiers() {
    \Drupal::service('shareholder_register.drush')
      ->updateIdentifiers();
  }

  /**
   * This command will update a shareholder.
   *
   * @param int $id
   *   Shareholder id.
   *
   * @command shareholder:update-shareholder
   * @aliases sr-us,update-shareholder
   */
  public function updateShareholder($id) {
    \Drupal::service('shareholder_register.drush')
      ->updateShareholder($id);
  }

  /**
   * This command will export the certificates.
   *
   * @command shareholder:certificates
   * @aliases sr-cert,shareholder-certificates
   */
  public function certificates() {
    \Drupal::service('shareholder_register.drush')
      ->exportCertificates();
  }

  /**
   * This command will validatae a single transaction from the register.
   *
   * @param int $id
   *   Transaction id.
   * @param bool $skip
   *   Skip issuing of shares (for large transactions).
   *
   * @command shareholder:validate-transaction
   * @aliases validate-transaction
   */
  public function validatedTransaction($id, $skip = FALSE) {
    \Drupal::service('shareholder_register.drush')
      ->validateTransaction($id, $skip);
  }

  /**
   * This command will delete a single transaction from the register.
   *
   * @param int $id
   *   Transaction id.
   *
   * @command shareholder:cancel-validated-transaction
   * @aliases cancel-validated-transaction
   */
  public function cancelValidatedTransaction($id) {
    \Drupal::service('shareholder_register.drush')
      ->cancelValidatedTransaction($id);
  }

  /**
   * This command will issue shares for all validated transactions.
   *
   * @command shareholder:cancel-validated-transaction
   * @aliases cancel-validated-transaction
   */
  public function issueSharesForTransactions() {
    \Drupal::service('shareholder_register.drush')
      ->issueSharesForTransactions();
  }

  /**
   * This command will perform an integrity check for the register.
   *
   * @command shareholder:integrity-check
   * @aliases integrity-check
   */
  public function integrityCheck() {
    \Drupal::service('shareholder_register.drush')
      ->integrityCheck();
  }

}
