<?php

namespace Drupal\shareholder_register\Controller;

use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;

use Drupal\mail_template\MailTemplateServiceInterface;

use Drupal\shareholder_register\Entity\ShareTransactionInterface;

/**
 * Class ShareTransactionController.
 *
 *  Returns responses for ShareTransaction routes.
 */
class ShareTransactionController extends ControllerBase implements ContainerInjectionInterface {

  /**
   * Drupal\mail_template\MailTemplateServiceInterface definition.
   *
   * @var \Drupal\mail_template\MailTemplateServiceInterface
   */
  protected $mailTemplateDefault;

  /**
   * Constructs a new CreatePackagesForm object.
   */
  public function __construct(
    MailTemplateServiceInterface $mailTemplateDefault
  ) {
    $this->mailTemplateDefault = $mailTemplateDefault;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('mail_template.default')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function downloadExtract(ShareTransactionInterface $share_transaction) {
    $context = ['transaction' => $share_transaction];
    $file = $this->mailTemplateDefault->pdfForRenderArrays([
      $this->mailTemplateDefault->renderArrayForTemplate('sharetransaction_extract', $context),
    ]);

    return $this->mailTemplateDefault->downloadForFile(
      $file, $filename = 'extract.pdf');
  }

  /**
   * {@inheritdoc}
   */
  public function downloadRequest(ShareTransactionInterface $share_transaction) {
    $context = ['transaction' => $share_transaction];
    $file = $this->mailTemplateDefault->pdfForRenderArrays([
      $this->mailTemplateDefault->renderArrayForTemplate('sharetransaction_request', $context),
    ]);

    return $this->mailTemplateDefault->downloadForFile(
      $file, $filename = 'request.pdf');

  }

}
