<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Share entities.
 *
 * @ingroup shareholder_register
 */
interface ShareInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Share name.
   *
   * @return string
   *   Name of the Share.
   */
  public function getName();

  /**
   * Sets the Share name.
   *
   * @param string $name
   *   The Share name.
   *
   * @return \Drupal\shareholder_register\Entity\ShareInterface
   *   The called Share entity.
   */
  public function setName($name);

  /**
   * Gets the Share creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Share.
   */
  public function getCreatedTime();

  /**
   * Sets the Share creation timestamp.
   *
   * @param int $timestamp
   *   The Share creation timestamp.
   *
   * @return \Drupal\shareholder_register\Entity\ShareInterface
   *   The called Share entity.
   */
  public function setCreatedTime($timestamp);

}
