<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Share issue entities.
 *
 * @ingroup shareholder_register
 */
interface ShareIssueInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  /**
   * Gets the Share issue name.
   *
   * @return string
   *   Name of the Share issue.
   */
  public function getName();

  /**
   * Sets the Share issue name.
   *
   * @param string $name
   *   The Share issue name.
   *
   * @return \Drupal\shareholder_register\Entity\ShareIssueInterface
   *   The called Share issue entity.
   */
  public function setName($name);

  /**
   * Gets the Share issue creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Share issue.
   */
  public function getCreatedTime();

  /**
   * Sets the Share issue creation timestamp.
   *
   * @param int $timestamp
   *   The Share issue creation timestamp.
   *
   * @return \Drupal\shareholder_register\Entity\ShareIssueInterface
   *   The called Share issue entity.
   */
  public function setCreatedTime($timestamp);

}
