<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Share Transaction Group entities.
 *
 * @ingroup shareholder_register
 */
interface ShareTransactionGroupInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Share Transaction Group name.
   *
   * @return string
   *   Name of the Share Transaction Group.
   */
  public function getName();

  /**
   * Sets the Share Transaction Group name.
   *
   * @param string $name
   *   The Share Transaction Group name.
   *
   * @return \Drupal\shareholder_register\Entity\ShareTransactionGroupInterface
   *   The called Share Transaction Group entity.
   */
  public function setName($name);

  /**
   * Gets the Share Transaction Group creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Share Transaction Group.
   */
  public function getCreatedTime();

  /**
   * Sets the Share Transaction Group creation timestamp.
   *
   * @param int $timestamp
   *   The Share Transaction Group creation timestamp.
   *
   * @return \Drupal\shareholder_register\Entity\ShareTransactionGroupInterface
   *   The called Share Transaction Group entity.
   */
  public function setCreatedTime($timestamp);

}
