<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Share Transaction Group type entity.
 *
 * @ConfigEntityType(
 *   id = "share_transaction_group_type",
 *   label = @Translation("Share Transaction Group type"),
 *   handlers = {
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *     "list_builder" = "Drupal\shareholder_register\ShareTransactionGroupTypeListBuilder",
 *     "form" = {
 *       "add" = "Drupal\shareholder_register\Form\ShareTransactionGroupTypeForm",
 *       "edit" = "Drupal\shareholder_register\Form\ShareTransactionGroupTypeForm",
 *       "delete" = "Drupal\shareholder_register\Form\ShareTransactionGroupTypeDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\shareholder_register\ShareTransactionGroupTypeHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "share_transaction_group_type",
 *   admin_permission = "administer site configuration",
 *   bundle_of = "share_transaction_group",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "canonical" = "/admin/shareholder_register/config/share_transaction_group_type/{share_transaction_group_type}",
 *     "add-form" = "/admin/shareholder_register/config/share_transaction_group_type/add",
 *     "edit-form" = "/admin/shareholder_register/config/share_transaction_group_type/{share_transaction_group_type}/edit",
 *     "delete-form" = "/admin/shareholder_register/config/share_transaction_group_type/{share_transaction_group_type}/delete",
 *     "collection" = "/admin/shareholder_register/config/share_transaction_group_type"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "baseType"
 *   }
 * )
 */
class ShareTransactionGroupType extends ConfigEntityBundleBase implements ShareTransactionGroupTypeInterface {

  const BASE_ISSUE = 'issue';
  const BASE_TRANSFER = 'transfer';
  const BASE_REDEMPTION = 'redemption';

  /**
   * The Share Transaction Group type ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Share Transaction Group type label.
   *
   * @var string
   */
  protected $label;

  /**
   * The Share Transaction Group base type.
   *
   * Can be one of: 'issue', 'transfer', 'redemption'
   *
   * @var string
   */
  protected $baseType;

  /**
   * {@inheritdoc}
   */
  public function getBaseType() {
    return $this->baseType;
  }

  /**
   * {@inheritdoc}
   */
  public function setBaseType($value) {
    $this->baseType = $value;
  }

}
