<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Share transaction entities.
 *
 * @ingroup shareholder_register
 */
interface ShareTransactionInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Share transaction name.
   *
   * @return string
   *   Name of the Share transaction.
   */
  public function getName();

  /**
   * Sets the Share transaction name.
   *
   * @param string $name
   *   The Share transaction name.
   *
   * @return \Drupal\shareholder_register\Entity\ShareTransactionInterface
   *   The called Share transaction entity.
   */
  public function setName($name);

  /**
   * Gets the Share transaction creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Share transaction.
   */
  public function getCreatedTime();

  /**
   * Sets the Share transaction creation timestamp.
   *
   * @param int $timestamp
   *   The Share transaction creation timestamp.
   *
   * @return \Drupal\shareholder_register\Entity\ShareTransactionInterface
   *   The called Share transaction entity.
   */
  public function setCreatedTime($timestamp);

}
