<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Share type entities.
 *
 * @ingroup shareholder_register
 */
interface ShareTypeInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Share type name.
   *
   * @return string
   *   Name of the Share type.
   */
  public function getName();

  /**
   * Sets the Share type name.
   *
   * @param string $name
   *   The Share type name.
   *
   * @return \Drupal\shareholder_register\Entity\ShareTypeInterface
   *   The called Share type entity.
   */
  public function setName($name);

  /**
   * Gets the Share type creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Share type.
   */
  public function getCreatedTime();

  /**
   * Sets the Share type creation timestamp.
   *
   * @param int $timestamp
   *   The Share type creation timestamp.
   *
   * @return \Drupal\shareholder_register\Entity\ShareTypeInterface
   *   The called Share type entity.
   */
  public function setCreatedTime($timestamp);

}
