<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\RevisionLogInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Shareholder entities.
 *
 * @ingroup shareholder_register
 */
interface ShareholderInterface extends ContentEntityInterface, RevisionLogInterface, EntityChangedInterface, EntityOwnerInterface {

  /**
   * Gets the Shareholder name.
   *
   * @return string
   *   Name of the Shareholder.
   */
  public function getName();

  /**
   * Sets the Shareholder name.
   *
   * @param string $name
   *   The Shareholder name.
   *
   * @return \Drupal\shareholder_register\Entity\ShareholderInterface
   *   The called Shareholder entity.
   */
  public function setName($name);

  /**
   * Gets the Share Count.
   *
   * @return integer
   *   Number of shares held.
   */
  public function getShareCount();

  /**
   * Gets the Shareholder creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Shareholder.
   */
  public function getCreatedTime();

  /**
   * Sets the Shareholder creation timestamp.
   *
   * @param int $timestamp
   *   The Shareholder creation timestamp.
   *
   * @return \Drupal\shareholder_register\Entity\ShareholderInterface
   *   The called Shareholder entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Gets the Shareholder revision creation timestamp.
   *
   * @return int
   *   The UNIX timestamp of when this revision was created.
   */
  public function getRevisionCreationTime();

  /**
   * Sets the Shareholder revision creation timestamp.
   *
   * @param int $timestamp
   *   The UNIX timestamp of when this revision was created.
   *
   * @return \Drupal\shareholder_register\Entity\ShareholderInterface
   *   The called Shareholder entity.
   */
  public function setRevisionCreationTime($timestamp);

  /**
   * Gets the Shareholder revision author.
   *
   * @return \Drupal\user\UserInterface
   *   The user entity for the revision author.
   */
  public function getRevisionUser();

  /**
   * Sets the Shareholder revision author.
   *
   * @param int $uid
   *   The user ID of the revision author.
   *
   * @return \Drupal\shareholder_register\Entity\ShareholderInterface
   *   The called Shareholder entity.
   */
  public function setRevisionUserId($uid);

}
