<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Shareholder type entity.
 *
 * @ConfigEntityType(
 *   id = "shareholder_type",
 *   label = @Translation("Shareholder type"),
 *   handlers = {
 *     "access" = "Drupal\shareholder_register\ShareholderTypeAccessControlHandler",
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *     "list_builder" = "Drupal\shareholder_register\ShareholderTypeListBuilder",
 *     "form" = {
 *       "add" = "Drupal\shareholder_register\Form\ShareholderTypeForm",
 *       "edit" = "Drupal\shareholder_register\Form\ShareholderTypeForm",
 *       "delete" = "Drupal\shareholder_register\Form\ShareholderTypeDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\shareholder_register\ShareholderTypeHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "shareholder_type",
 *   admin_permission = "administer site configuration",
 *   bundle_of = "shareholder",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "canonical" = "/admin/structure/shareholder_type/{shareholder_type}",
 *     "add-form" = "/admin/structure/shareholder_type/add",
 *     "edit-form" = "/admin/structure/shareholder_type/{shareholder_type}/edit",
 *     "delete-form" = "/admin/structure/shareholder_type/{shareholder_type}/delete",
 *     "collection" = "/admin/structure/shareholder_type"
 *   },
 *   config_export = {
 *     "id",
 *     "label"
 *   }
 * )
 */
class ShareholderType extends ConfigEntityBundleBase implements ShareholderTypeInterface {

  /**
   * The Shareholder type ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Shareholder type label.
   *
   * @var string
   */
  protected $label;

}
