<?php

namespace Drupal\shareholder_register\Entity;

use Drupal\views\EntityViewsData;

/**
 * Provides Views data for Shareholder entities.
 */
class ShareholderViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();

    // Additional information for Views integration, such as table joins, can be
    // put here.
    $data['shareholder']['shareholder_shares_relationship'] = [
      'title' => t('Current Shares'),
      'help' => t('Provide the current Shares.'),
      'relationship' => [
        'label' => t('Current Shares'),
        'id' => 'standard',
        'group' => t('Shareholder'),
        'base' => 'share',
        'base field' => 'shareholder_id',
        'field' => 'id',
        /*
        'extra' => [
          0 => [
            'left_field' => 'state',
            'value' => ['issued'],
            'operator' => 'IN',
            'numeric' => TRUE,
          ],
        ],
        */
      ],
    ];

    return $data;
  }

}
