<?php
namespace Drupal\shareholder_register\Event;

use Drupal\shareholder_register\Entity\ShareTransactionInterface;
use Symfony\Component\EventDispatcher\Event;


/**
 * Share Transaction Event.
 *
 */
class ShareTransactionEvent extends Event {

  const VALIDATED_EVENT_NAME = 'shareholder_register_share_transaction_validated_event';
  const REFUSED_EVENT_NAME = 'shareholder_register_share_transaction_refused_event';
  const CANCELED_EVENT_NAME = 'shareholder_register_share_transaction_canceled_event';

  /**
   * The share transaction.
   *
   * @var \Drupal\shareholder_register\Entity\ShareTransactionInterface
   */
  protected $shareTransaction;

  /**
   * Constructs the object.
   *
   * @param \Drupal\shareholder_register\Entity\ShareTransactionInterface $shareTransaction
   *   The Share Transaction.
   */
  public function __construct(ShareTransactionInterface $shareTransaction) {
    $this->shareTransaction = $shareTransaction;
  }

  /**
   * {@inheritdoc}
   */
  public function getShareTransaction() {
    return $this->shareTransaction;
  }

}
