<?php
namespace Drupal\shareholder_register\Event;

use Drupal\shareholder_register\Entity\ShareTransactionGroupInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Share Transaction Group Event.
 *
 */
class ShareTransactionGroupEvent extends Event {

  const VALIDATED_EVENT_NAME = 'shareholder_register_share_transaction_group_validated_event';

  /**
   * The share transaction.
   *
   * @var \Drupal\shareholder_register\Entity\ShareTransactionGroupInterface
   */
  protected $shareTransactionGroup;

  /**
   * Constructs the object.
   *
   * @param \Drupal\shareholder_register\Entity\ShareTransactionGroupInterface $shareTransactionGroup
   *   The Share Transaction.
   */
  public function __construct(ShareTransactionGroupInterface $shareTransactionGroup) {
    $this->shareTransactionGroup = $shareTransactionGroup;
  }

  /**
   * {@inheritdoc}
   */
  public function getShareTransactionGroup() {
    return $this->shareTransactionGroup;
  }

}