<?php
namespace Drupal\shareholder_register\Event;

use Drupal\shareholder_register\Entity\ShareholderInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Shareholder Event.
 *
 */
class ShareholderEvent extends Event {

  const PRE_VALIDATE_EVENT_NAME = 'shareholder_register_shareholder_pre_validate_event';
  const VALIDATED_EVENT_NAME = 'shareholder_register_shareholder_validated_event';
  const REFUSED_EVENT_NAME = 'shareholder_register_shareholder_refused_event';
  const CANCELED_EVENT_NAME = 'shareholder_register_shareholder_canceled_event';

  /**
   * The shareholder.
   *
   * @var \Drupal\shareholder_register\Entity\ShareholderInterface
   */
  protected $shareholder;

  /**
   * Constructs the object.
   *
   * @param \Drupal\shareholder_register\Entity\ShareholderInterface $shareholder
   *   The Shareholder.
   */
  public function __construct(ShareholderInterface $shareholder) {
    $this->shareholder = $shareholder;
  }

  /**
   * {@inheritdoc}
   */
  public function getShareholder() {
    return $this->shareholder;
  }

}
