<?php

namespace Drupal\shareholder_register\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

use Drupal\shareholder_register\Event\ShareTransactionEvent;
use Drupal\shareholder_register\Event\ShareTransactionGroupEvent;

/**
 * Class ShareTransactionEventSubscriber.
 *
 * @package Drupal\shareholder_register
 */
class ShareTransactionEventSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events[ShareTransactionGroupEvent::VALIDATED_EVENT_NAME][] = [
      'sendShareTransactionMail',
      800
    ];
    $events[ShareTransactionEvent::VALIDATED_EVENT_NAME][] = [
      'updateShareholder',
      800
    ];
    return $events;
  }

  /**
   * Subscriber Callback for the event.
   *
   * @param \Drupal\shareholder_register\Event\ShareTransactionGroupEvent $event
   *   The event.
   */
  public function sendShareTransactionMail(ShareTransactionGroupEvent $event) {
    $config = \Drupal::config('shareholder_register.settings');
    if (!$config->get('mail_extract_upon_validation')) {
      return;
    }

    $group = $event->getShareTransactionGroup();

    if ($config->get('limit_automatic_mail_extract_upon_validation') &&
      !in_array($group->bundle(), $config->get('limit_automatic_mail_extract_upon_validation_types'), TRUE)) {
      return;
    }

    foreach ($group->getTransactions() as $transaction) {
      $shareholder = $transaction->getShareholder();

      if ($shareholder->get('deceased_date')->value) {
        continue;
      }

      $ctx = [
        'transaction' => $transaction,
        'transaction_id' => $transaction->id(),
        'template_variants' => [
          "mail_shareholder_extract_{$group->getShareGroupTypeBaseType()}_transaction_validated",
          'mail_shareholder_extract_transaction_validated',
        ],
      ];
      $shareholder->sendExtractMail($ctx);
    }
  }

  /**
   * Subscriber Callback for the event.
   *
   * @param \Drupal\shareholder_register\Event\ShareTransactionEvent $event
   *   The event.
   */
  public function updateShareholder(ShareTransactionEvent $event) {
    // Save to trigger computation of current status
    // and cache clear for share count.
    $event->getShareTransaction()->getShareholder()->save();
  }
}
