<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormState;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;

use Drupal\Component\Utility\NestedArray;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class ExportShareholderRegisterForm.
 */
class ExportShareholderRegisterForm extends FormBase {

  /**
   * Drupal\shareholder_register\ShareholderRegisterExportServiceInterface definition.
   *
   * @var \Drupal\shareholder_register\ShareholderRegisterExportServiceInterface
   */
  protected $shareholderRegisterExport;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->shareholderRegisterExport = $container->get('shareholder_register.export');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'export_shareholder_register_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $this->manager = \Drupal::service('plugin.manager.shareholder_register_export_plugin');
    $export_options = array_column(
      $this->manager->getDefinitions(),
      'label',
      'id'
    );

    $wrapper_id = 'ajax-wrapper';
    $form['plugin'] = [
      '#type' => 'select',
      '#title' => $this->t('Plugin'),
      '#options' => $export_options,
      '#weight' => '15',
      '#required' => TRUE,
      '#ajax' => [
        'callback' => [get_called_class(), 'updatePlugin'],
        'wrapper' => $wrapper_id,
      ]
    ];

    $form['plugin_settings_wrapper'] = [
      '#weight' => '20',
      '#tree' => TRUE,
      '#prefix' => '<div id="' . $wrapper_id . '">',
      '#suffix' => '</div>',
    ];

    if ($form_state->getValue('plugin')) {
      $plugin_id = $form_state->getValue('plugin');
      $plugin_values = $form_state->getValue(['plugin_settings_wrapper']);
      $plugin = $this->manager->createInstance($plugin_id, $plugin_values ? $plugin_values : []);
      if ($plugin instanceof PluginFormInterface) {
        $form['plugin_settings_wrapper'] += $plugin->buildConfigurationForm([], $form_state);
      }
    }

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
      '#weight' => '30',
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public static function updatePlugin(array $form, FormStateInterface $form_state) {
    $subform = NestedArray::getValue($form, ['plugin_settings_wrapper']);
    return $subform;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    $this->manager = \Drupal::service('plugin.manager.shareholder_register_export_plugin');
    if ($form_state->getValue('plugin')) {
      $plugin_id = $form_state->getValue('plugin');
      $plugin = $this->manager->createInstance($plugin_id, []);
      $plugin_values = $form_state->getValue(['plugin_settings_wrapper']);
      if ($plugin_values) {
        $plugin->validateConfigurationForm($form, $form_state);
      }
    }

    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->manager = \Drupal::service('plugin.manager.shareholder_register_export_plugin');

    if ($form_state->getValue('plugin')) {
      $plugin_id = $form_state->getValue('plugin');
      $plugin = $this->manager->createInstance($plugin_id, []);
      $plugin_values = $form_state->getValue(['plugin_settings_wrapper']);
      if ($plugin_values) {
        $sub_form_state = new FormState();
        $sub_form_state->setValues($plugin_values);
        $plugin->submitConfigurationForm($form, $sub_form_state);
      }
    }

    $batch = $plugin->getExportBatch();
    batch_set($batch);
  }

}
