<?php

namespace Drupal\shareholder_register\Form;

use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\shareholder_register\Entity\ShareIssue;
use Drupal\shareholder_register\Form\ShareTransactionForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Issue Share transaction forms.
 *
 * @ingroup shareholder_register
 */
class IssueShareTransactionForm extends ShareTransactionForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, Shareholder $shareholder = NULL) {
    $form = parent::buildForm($form, $form_state, $shareholder);

    $form['date']['widget'][0]['value']['#access'] = FALSE;
    $form['exit_disbursement']['widget'][0]['value']['#access'] = FALSE;

    $form['share_type_id']['widget'][0]['target_id']['#required'] = FALSE;
    $form['share_type_id']['widget'][0]['target_id']['#access'] = FALSE;
    $form['share_issue_id']['widget'][0]['target_id']['#required'] = TRUE;
    $form['share_issue_id']['widget'][0]['target_id']['#access'] = TRUE;
    $form['share_issue_id']['widget'][0]['target_id']['#ajax'] = [
      'callback' => [$this, 'updateIssuePremium'],
      'event' => 'change',
      'wrapper' => 'edit-issue-premium-wrapper',
    ];

    $form['quantity']['widget'][0]['value']['#default_value'] = 1;
    $form['quantity']['widget'][0]['value']['#min'] = 1;
    $form['quantity']['widget'][0]['value']['#required'] = TRUE;

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function updateIssuePremium(array &$form, FormStateInterface $form_state) : array {
    $issue = $form_state->getValue(['share_issue_id', 0, 'target_id']);
    if ($issue) {
      $i = ShareIssue::load($issue);
      $form['issue_premium']['widget'][0]['value']['#value'] = $i->getIssuePremium();
    }
    return $form['issue_premium'];
  }
}
