<?php

namespace Drupal\shareholder_register\Form;

use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Issue Share transaction forms.
 *
 * @ingroup shareholder_register
 */
class RepurchaseShareTransactionForm extends ShareTransactionForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, Shareholder $shareholder = NULL) {
    $form = parent::buildForm($form, $form_state, $shareholder);

    $form['date']['widget'][0]['value']['#access'] = FALSE;
    $form['payment_date']['widget'][0]['value']['#access'] = FALSE;
    $form['issue_premium']['widget'][0]['value']['#access'] = FALSE;
    $form['share_issue_id']['widget'][0]['target_id']['#access'] = FALSE;

    $form['quantity']['widget'][0]['value']['#default_value'] = -1;
    $form['quantity']['widget'][0]['value']['#max'] = -1;
    $form['quantity']['widget'][0]['value']['#required'] = TRUE;

    /*
    $form['shares'] = [
      '#type' => 'entity_autocomplete',
      '#title' => t('Shares'),
      '#description' => t('Fill in the shares if you want to repurchase specific shares.'),
      '#target_type' => 'share',
      '#tags' => TRUE,
    ];
    */

    return $form;
  }

}
