<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Entity\Shareholder;

/**
 * Class RequestShareholderRegisterExtractForm.
 */
class RequestShareholderRegisterExtractForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'request_shareholder_register_extract_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['header'] = [
      '#markup' => t('<p>Fill out this form to receive an up to date extract from the shareholder register.</p>'),
    ];
    $form['mail'] = [
      '#type' => 'email',
      '#title' => $this->t('Your registered email address'),
      '#weight' => '0',
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $query = \Drupal::entityQuery('shareholder')
      ->condition('mail', $form_state->getValue('mail'));
    $values = $query->execute();
    if (count($values) < 1) {
        $form_state->setErrorByName(
          'email',
          t('Your mail address could not be found in the register!')
        );
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $query = \Drupal::entityQuery('shareholder')
      ->condition('mail', $form_state->getValue('mail'));
    $values = $query->execute();
    foreach (Shareholder::loadMultiple($values) as $shareholder) {
      $shareholder->sendExtractMail();
    }
    $form_state->setRedirect('<front>');
  }

}
