<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class ShareTransactionGroupTypeForm.
 */
class ShareTransactionGroupTypeForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $share_transaction_group_type = $this->entity;
    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 255,
      '#default_value' => $share_transaction_group_type->label(),
      '#description' => $this->t("Label for the Share Transaction Group type."),
      '#required' => TRUE,
    ];

    $form['baseType'] = [
      '#type' => 'select',
      '#title' => $this->t('Base type'),
      '#options' => [
        'issue' => $this->t('Share issue'),
        'transfer' => $this->t('Share transfer'),
        'redemption' => $this->t('Share redemption/repurchase'),
      ],
      '#default_value' => $share_transaction_group_type->getBaseType(),
      '#description' => $this->t("Base type for the Share Transaction Group type."),
      '#required' => TRUE,
    ];

    $form['id'] = [
      '#type' => 'machine_name',
      '#default_value' => $share_transaction_group_type->id(),
      '#machine_name' => [
        'exists' => '\Drupal\shareholder_register\Entity\ShareTransactionGroupType::load',
      ],
      '#disabled' => !$share_transaction_group_type->isNew(),
    ];

    /* You will need additional form elements for your custom properties. */

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $share_transaction_group_type = $this->entity;
    $status = $share_transaction_group_type->save();

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addMessage($this->t('Created the %label Share Transaction Group type.', [
          '%label' => $share_transaction_group_type->label(),
        ]));
        break;

      default:
        $this->messenger()->addMessage($this->t('Saved the %label Share Transaction Group type.', [
          '%label' => $share_transaction_group_type->label(),
        ]));
    }
    $form_state->setRedirectUrl($share_transaction_group_type->toUrl('collection'));
  }

}
