<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

use Drupal\shareholder_register\Entity\ShareTransaction;

/**
 * Class ShareTransactionRefuseForm.
 */
class ShareTransactionRefuseForm extends FormBase {


  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'share_transaction_refuse_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $current_url = Url::fromRoute('<current>')->toString();
    $params = Url::fromUserInput($current_url)->getRouteParameters();
    $form_state->getStorage()['transaction'] = $params['share_transaction'];

    $form['date'] = [
      '#type' => 'date',
      '#title' => $this->t('Date'),
      '#description' => $this->t('The date for the registration'),
      '#required' => TRUE,
      '#default_value' => date('Y-m-d'),
    ];
    $form['notes'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Notes'),
      '#description' => $this->t('Please provide the reason for refusing this transaction'),
      '#weight' => '0',
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $transaction = ShareTransaction::load($form_state->getStorage()['transaction']);
    $transaction->actionRefuse(
      $form_state->getValue('date'),
      $form_state->getValue('notes'));
  }

}
