<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Shareholder edit forms.
 *
 * @ingroup shareholder_register
 */
class ShareholderForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    // Always save a new revision when editing a shareholder.
    if (!$this->entity->isNew()) {
      $entity->setNewRevision();

      // If a new revision is created, save the current user as revision author.
      $entity->setRevisionCreationTime(REQUEST_TIME);
      $entity->setRevisionUserId(\Drupal::currentUser()->id());
    }

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addMessage($this->t('Created the %label Shareholder.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        $this->messenger()->addMessage($this->t('Saved the %label Shareholder.', [
          '%label' => $entity->label(),
        ]));
    }
    //$form_state->setRedirect('entity.shareholder.canonical', ['shareholder' => $entity->id()]);
    $form_state->setRedirect('view.shareholders.page_2');
  }

}
