<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Entity\Share;
use Drupal\shareholder_register\Entity\ShareTransactionGroupType;

/**
 * Class ShareholderRegisterConfigForm.
 */
class ShareholderRegisterConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'shareholder_register.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'shareholder_register_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('shareholder_register.settings');

    $form['company'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Company information'),
    ];

    $form['company']['company_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Name'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_name'),
    ];
    $form['company']['company_address'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Address'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_address'),
    ];
    $form['company']['company_zip'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Zip code'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_zip'),
    ];
    $form['company']['company_locality'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Locality'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_locality'),
    ];
    $form['company']['company_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Company ID'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_id'),
    ];
    $form['company']['company_date_of_incorporation'] = [
      '#type' => 'date',
      '#title' => $this->t('Date of incorporation'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_date_of_incorporation'),
    ];

    $form['mail_extract_upon_validation'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Automatically send register extract upon validation ?'),
      '#default_value' => $config->get('mail_extract_upon_validation'),
    ];

    $form['mail_extract_upon_validation_options'] = [
      '#type' => 'fieldset',
      '#title' => $this->t("Automatic register certificate options"),
      '#states' => [
        'visible' => [
          ':input[name="mail_extract_upon_validation"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['mail_extract_upon_validation_options']['limit_automatic_mail_extract_upon_validation'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Limit automatically sent register extract to selected transaction types.'),
      '#default_value' => $config->get('limit_automatic_mail_extract_upon_validation'),
    ];

    $options = [];
    foreach (ShareTransactionGroupType::loadMultiple() as $t) {
      $options[$t->id()] = $t->label();
    }

    $form['mail_extract_upon_validation_options']['limit_automatic_mail_extract_upon_validation_types'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Transaction types.'),
      '#options' => $options,
      '#default_value' => $config->get('limit_automatic_mail_extract_upon_validation_types'),
    ];

    $form['automatic_validation'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Automatically validate new transactions ?'),
      '#default_value' => $config->get('automatic_validation'),
    ];

    $form['share-hash-fields'] = [
      '#type' => 'fieldset',
      '#tree' => TRUE,
      '#title' => $this->t('Share hash fields'),
    ];

    $fields = $config->get('share_hash_fields') ? $config->get('share_hash_fields') : [];
    foreach (array_merge($fields, ['new' => ['field_name' => 'new']]) as $item) {
      $item_id = $item['field_name'];

      $form['share-hash-fields'][$item_id] = [
        '#type' => 'fieldset',
      ];
      $form['share-hash-fields'][$item_id]['field_name'] = [
        '#type' => 'textfield',
        '#title' => $this->t('Field Name'),
        '#default_value' => $item_id === 'new' ? '' : $item['field_name'],
      ];
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $fields = \Drupal::service('entity_field.manager')->getFieldDefinitions('share', 'share');

    $field_config = [];
    foreach ($form_state->getValue('share-hash-fields') as $k => $v) {
      if (!trim($v['field_name']) || !$v['field_name']) {
        continue;
      }
      if (!isset($fields[$v['field_name']])) {
        continue;
      }
      $field_config[] = [
        'field_name' => $v['field_name'],
        'field_type' => $fields[$v['field_name']]->getType(),
        'field_label' => $fields[$v['field_name']]->getLabel(),
      ];
    }

    $this->config('shareholder_register.settings')
      ->set('mail_extract_upon_validation', $form_state->getValue('mail_extract_upon_validation'))
      ->set('limit_automatic_mail_extract_upon_validation', $form_state->getValue('limit_automatic_mail_extract_upon_validation'))
      ->set('limit_automatic_mail_extract_upon_validation_types', $form_state->getValue('limit_automatic_mail_extract_upon_validation_types'))
      ->set('automatic_validation', $form_state->getValue('automatic_validation'))
      ->set('company_name', $form_state->getValue('company_name'))
      ->set('company_address', $form_state->getValue('company_address'))
      ->set('company_zip', $form_state->getValue('company_zip'))
      ->set('company_locality', $form_state->getValue('company_locality'))
      ->set('company_id', $form_state->getValue('company_id'))
      ->set('company_date_of_incorporation', $form_state->getValue('company_date_of_incorporation'))
      ->set('share_hash_fields', $field_config)
      ->save();
  }

}
