<?php

namespace Drupal\shareholder_register\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class ShareholderTypeForm.
 */
class ShareholderTypeForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $shareholder_type = $this->entity;
    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 255,
      '#default_value' => $shareholder_type->label(),
      '#description' => $this->t("Label for the Shareholder type."),
      '#required' => TRUE,
    ];

    $form['id'] = [
      '#type' => 'machine_name',
      '#default_value' => $shareholder_type->id(),
      '#machine_name' => [
        'exists' => '\Drupal\shareholder_register\Entity\ShareholderType::load',
      ],
      '#disabled' => !$shareholder_type->isNew(),
    ];

    /* You will need additional form elements for your custom properties. */

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $shareholder_type = $this->entity;
    $status = $shareholder_type->save();

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addMessage($this->t('Created the %label Shareholder type.', [
          '%label' => $shareholder_type->label(),
        ]));
        break;

      default:
        $this->messenger()->addMessage($this->t('Saved the %label Shareholder type.', [
          '%label' => $shareholder_type->label(),
        ]));
    }
    $form_state->setRedirectUrl($shareholder_type->toUrl('collection'));
  }

}
