<?php
namespace Drupal\shareholder_register\Plugin\Action;

use Drupal\views_bulk_operations\Action\ViewsBulkOperationsActionBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Cancel Share Transaction.
 *
 * @Action(
 *   id = "cancel_share_transaction_action",
 *   label = @Translation("Cancel Share Transaction"),
 *   type = "share_transaction"
 * )
 */
class CancelShareTransactionAction extends ViewsBulkOperationsActionBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'date' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['date'] = [
      '#type' => 'date',
      '#title' => $this->t('Date'),
      '#description' => $this->t('The date for the registration'),
      '#required' => TRUE,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    $entity->actionCancel();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    if ($object->getState() != 'draft') {
      $result = AccessResult::forbidden();
    }
    else {
      $result = $object->access('update', $account, TRUE);
    }
    return $return_as_object ? $result : $result->isAllowed();
  }

}
