<?php
namespace Drupal\shareholder_register\Plugin\Action;

use Drupal\views_bulk_operations\Action\ViewsBulkOperationsActionBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Cancel Shareholder.
 *
 * @Action(
 *   id = "cancel_shareholder_action",
 *   label = @Translation("Cancel Shareholder"),
 *   type = "shareholder"
 * )
 */
class CancelShareholderAction extends ViewsBulkOperationsActionBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'date' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    $transactions = array_filter(
      $entity->getTransactions(),
      function ($t) {
        return in_array($t->getState(), ['draft', 'valid']);
      }
    );

    if ($entity->getState() !== 'draft') {
      \Drupal::service('messenger')->addWarning($this->t(
          "Not cancelling shareholder @name: not in state 'draft'!",
          ['@name' => $entity->getName()])
      );
    }
    elseif (count($transactions)) {
      \Drupal::service('messenger')->addWarning($this->t(
          "Not cancelling shareholder @name: remaining 'draft' or 'valid' transactions!",
          ['@name' => $entity->getName()])
      );
    }
    else {
      $entity->actionCancel();
    }
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    if ($object->getState() != 'draft') {
      $result = AccessResult::forbidden();
    }
    else {
      $result = $object->access('update', $account, TRUE);
    }
    return $return_as_object ? $result : $result->isAllowed();
  }

}
