<?php
namespace Drupal\shareholder_register\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Mail Shareholder Extract.
 *
 * @Action(
 *   id = "mail_shareholder_extract_action",
 *   label = @Translation("Mail Shareholder Extract"),
 *   type = "shareholder"
 * )
 */
class MailShareholderExtractAction extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    if ($entity) {
      $entity->sendExtractMail();
    }
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    if ($object->getState() != 'valid') {
      $result = AccessResult::forbidden();
    }
    else {
      $result = $object->access('view', $account, TRUE);
    }
    return $return_as_object ? $result : $result->isAllowed();
  }

}
