<?php

namespace Drupal\shareholder_register\Plugin\Field\FieldFormatter;

use Drupal\Component\Utility\Html;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Entity\ShareTransaction;

/**
 * Plugin implementation of the 'share_transactions_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "share_transactions_formatter",
 *   label = @Translation("Share transactions formatter"),
 *   field_types = {
 *     "shareholder_share_transactions",
 *     "share_transaction_group_share_transactions"
 *   }
 * )
 */
class ShareTransactionsFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      // Implement default settings.
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    return [
      // Implement settings form.
    ] + parent::settingsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    // Implement settings summary.

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements[0] = [
      '#type' => 'table',
      '#cache' => [
        'tags' => \Drupal::entityTypeManager()->getDefinition('share_transaction')->getListCacheTags(),
      ],
      '#header' => [
        t('Date'),
        t('Number'),
        t('Type'),
        t('Par value'),
        t('Quantity'),
      ],
    ];
    $elements[1] = [
      '#type' => 'details',
      '#title' => $this->t('Other transactions'),
      'table' => [
        '#type' => 'table',
        '#cache' => [
          'tags' => \Drupal::entityTypeManager()->getDefinition('share_transaction')->getListCacheTags(),
        ],
        '#header' => [
          t('Date'),
          t('Number'),
          t('Type'),
          t('Par value'),
          t('Quantity'),
        ],
      ]
    ];

    foreach ($items as $delta => $item) {
      $value = $item->getValue();
      if (isset($value['entity'])) {
        $transaction = $value['entity'];
      }
      else {
        $transaction = ShareTransaction::load($value['target_id']);
      }

      if ($transaction->getState() === 'valid') {
        $elements[0]['#rows'][$delta] = $this->viewValue($item);
      }
      else {
        $elements[1]['table']['#rows'][$delta] = $this->viewValue($item);
      }
    }

    return $elements;
  }

  /**
   * Generate the output appropriate for one field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One field item.
   *
   * @return string
   *   The textual output generated.
   */
  protected function viewValue(FieldItemInterface $item) {
    $value = $item->getValue();
    if (isset($value['entity'])) {
      $transaction = $value['entity'];
    }
    else {
      $transaction = ShareTransaction::load($value['target_id']);
    }

    $group = $transaction->getTransactionGroup();
    return [
      'date' => $transaction->getDate(),
      'number' => $transaction->getName(),
      'type' => $group ? $group->bundle() : '',
      'par' => $transaction->getParValue(),
      'quantity' => $transaction->getQuantity(),
    ];
  }

}
