<?php

namespace Drupal\shareholder_register\Plugin\Field\FieldFormatter;

use Drupal\Component\Utility\Html;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Plugin\Field\FieldType\AddressFieldType;

/**
 * Plugin implementation of the 'shareholder_address_property_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "shareholder_address_property formatter",
 *   label = @Translation("Shareholder address property formatter"),
 *   field_types = {
 *     "address_field_type"
 *   }
 * )
 */
class ShareholderAddressPropertyFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      'property' => 'given_name',
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $options = [];
    foreach (AddressFieldType::getDefinition() as $k => $v) {
      $options[$k] = $v['label'];
    }

    return [
      'property' => [
        "#type" => "select",
        "#title" => t("Property"),
        "#options" => $options,
        "#default_value" => $this->getSetting('property'),
      ]
    ] + parent::settingsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    // Implement settings summary.

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $this->viewValue($item)];
    }

    return $elements;
  }

  /**
   * Generate the output appropriate for one field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One field item.
   *
   * @return string
   *   The textual output generated.
   */
  protected function viewValue(FieldItemInterface $item) {
    return nl2br(Html::escape($item->{$this->getSetting('property')}));
  }

}
