<?php

namespace Drupal\shareholder_register\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

use Drupal\shareholder_register\Entity\ShareholderInterface;
use Drupal\shareholder_register\Entity\ShareTypeInterface;

/**
 * {@inheritdoc}
 */
class ShareTotalValueItemList extends FieldItemList {
  use ComputedItemListTrait;

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    $computed_values = [0];

    $entity = $this->getEntity();
    if (!$entity->isNew()) {
      $value = 0;
      if ($entity instanceof ShareholderInterface) {
        $connection = \Drupal::database();
        $r = $connection->query(
          "SELECT SUM(quantity * share_value) AS value FROM {share_transaction} WHERE state = 'valid' AND shareholder_id = :shareholder",
          [
            ':shareholder' => $entity->id(),
          ]);
        $computed_values[0] = $r->fetchAssoc()['value'];
      }
      elseif ($entity instanceof ShareTypeInterface) {
        $connection = \Drupal::database();
        $r = $connection->query(
          "SELECT SUM(quantity * share_value) AS value FROM {share_transaction} WHERE state = 'valid' AND share_type_id = :share_type",
          [
            ':share_type' => $entity->id(),
          ]);
        $computed_values[0] = $r->fetchAssoc()['value'];
      }
    }

    foreach ($computed_values as $delta => $value) {
      $this->list[$delta] = $this->createItem($delta, $value);
    }
  }

}
