<?php

namespace Drupal\shareholder_register\Plugin\Field\FieldType;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

use Drupal\shareholder_register\Entity\Share;

/**
 * {@inheritdoc}
 */
class ShareTransactionSharesItemList extends EntityReferenceFieldItemList {
  use ComputedItemListTrait;

  /**
   * Compute the values.
   */
  protected function computeValue() {
    $entity = $this->getEntity();

    $values = Share::loadMultiple(
      \Drupal::entityQuery('share')
        ->condition('share_transaction_ids', $entity->id())
        ->execute()
    );

    if ($values) {
      $n = 0;
      foreach ($values as $delta => $value) {
        $this->list[$n] = $this->createItem($delta, $value);
        $n++;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function referencedEntities() {
    $this->ensureComputedValue();
    return parent::referencedEntities();
  }

  /**
   * {@inheritdoc}
   */
  public function getReferencedEntities() {
    // Duplicate method, with prefix get for use in twig templates.
    $this->valueComputed = FALSE;
    return $this->referencedEntities();
  }

}
