<?php

namespace Drupal\shareholder_register\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'shareholder_address_widget' widget.
 *
 * @FieldWidget(
 *   id = "shareholder_address_widget",
 *   label = @Translation("Shareholder address widget"),
 *   field_types = {
 *     "address_field_type"
 *   }
 * )
 */
class ShareholderAddressWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      'use_organization' => FALSE,
      'use_premise_and_subpremise' => FALSE,
      'default_country_code' => FALSE,
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $elements = [];

    $elements['use_organization'] = [
      '#type' => 'checkbox',
      '#title' => t('Use Organization'),
      '#description' => t('Checking this will make the organization field required and the given and family name optional.'),
      '#default_value' => $this->getSetting('use_organization'),
    ];
    $elements['use_premise_and_subpremise'] = [
      '#type' => 'checkbox',
      '#title' => t('Use Premise and Subpremise'),
      '#default_value' => $this->getSetting('use_premise_and_subpremise'),
      '#description' => t('If checked the premise and subpremise fields will be shown.'),
    ];
    $elements['default_country_code'] = [
      '#type' => 'select',
      '#title' => t('Default Country Code'),
      '#default_value' => $this->getSetting('default_country_code'),
      '#description' => t('Default Country Code.'),
      '#options' => \Drupal::service('country_manager')->getList(),
    ];

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];

    $summary[] = t('Organization: @org', ['@org' => $this->getSetting('use_organization')]);
    $summary[] = t('Premise and Subpremise: @premise', ['@premise' => $this->getSetting('use_premise_and_subpremise')]);
    $summary[] = t('Default country code: @country_code', ['@country_code' => $this->getSetting('default_country_code')]);
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $item = $items[$delta];
    $value = $item->getEntity()->isNew() ? [] : $item->toArray();

    $element['address'] = [
      '#type' => 'address_field',
      '#default_value' => $value,
      '#address_options' => [
        'organization' => $this->getSetting('use_organization'),
        'premise_and_subpremise' => $this->getSetting('use_premise_and_subpremise'),
        'default_country_code' => $this->getSetting('default_country_code'),
      ]
    ];

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    $new_values = [];
    foreach ($values as $delta => $value) {
      $new_values[$delta] = $value['address'];
    }
    return $new_values;
  }

}
