<?php
namespace Drupal\shareholder_register\Plugin\ShareholderRegisterExportPlugin;

use Drupal\Core\Link;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

use Drupal\shareholder_register\Plugin\ShareholderRegisterExportPluginInterface;

/**
 * Export Register At Date.
 *
 * @ShareholderRegisterExportPlugin(
 *   id = "register_at_date",
 *   label = @Translation("Register At Date"),
 *  )
 */
class RegisterAtDate extends PluginBase implements PluginFormInterface, ShareholderRegisterExportPluginInterface {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {

    $form['date'] = [
      '#type' => 'date',
      '#title' => $this->t('Date'),
      '#required' => TRUE,
      '#weight' => '0',
    ];
    $form['use_payment_date'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use date of payment'),
      '#default_value' => TRUE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['form_values'] = $form_state->getValues();
  }

  /**
   * {@inheritdoc}
   */
  public function getExportBatch() {
    $config = [
      'date' => $this->configuration['form_values']['date'],
      'use_payment_date' => $this->configuration['form_values']['use_payment_date'],
      'compute_ids_callback' => 'Drupal\shareholder_register\ShareholderRegisterExportService::allValidShareholders',
      'compute_callback' => 'Drupal\shareholder_register\ShareholderRegisterExportService::shareholderAtDate',
      'write_callback' => 'Drupal\shareholder_register\ShareholderRegisterExportService::writeShareholderAtDate',
      'page_title' => $this->t(
        'Shareholder Register state at date @date (@type)',
        [
          '@date' => $this->configuration['form_values']['date'],
          '@type' => $this->configuration['form_values']['use_payment_date'] ? $this->t('Date of payment') : $this->t('Date of validation'),
        ]),
      'column_headers' => [
        $this->t('Shareholder Number'),
        $this->t('Shareholder Name'),
        $this->t('Email'),
        $this->t('Registration Date'),
        $this->t('Street'),
        $this->t('Housenumber'),
        $this->t('Box'),
        $this->t('Postal code'),
        $this->t('Locality'),
        $this->t('Country'),
        $this->t('Shares'),
        $this->t('Number of shares'),
      ],
    ];

    $this->shareholderRegisterExport = \Drupal::service('shareholder_register.export');
    $batch = $this->shareholderRegisterExport->getExportBatch($config);

    return $batch;
  }
}
