<?php

namespace Drupal\shareholder_register\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the Shareholder register export plugin plugin manager.
 */
class ShareholderRegisterExportPluginManager extends DefaultPluginManager {


  /**
   * Constructs a new ShareholderRegisterExportPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/ShareholderRegisterExportPlugin', $namespaces, $module_handler, 'Drupal\shareholder_register\Plugin\ShareholderRegisterExportPluginInterface', 'Drupal\shareholder_register\Annotation\ShareholderRegisterExportPlugin');

    $this->alterInfo('shareholder_register_shareholder_register_export_plugin_info');
    $this->setCacheBackend($cache_backend, 'shareholder_register_shareholder_register_export_plugin_plugins');
  }

}
