<?php

namespace Drupal\shareholder_register\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the share issue constraint.
 */
class ShareIssueConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate($entity, Constraint $constraint) {
    if (!isset($entity)) {
      return;
    }

    if ($entity->getQuantity() < 0 && $entity->getShareIssue()) {
      $this->context->buildViolation($constraint->message)
        ->addViolation();
      return;
    }

    if ($entity->getQuantity() > 0) {
      if (!$entity->getShareIssue()) {
        $this->context->buildViolation($constraint->message)
          ->addViolation();
        return;
      }
    }
  }

}
