<?php

namespace Drupal\shareholder_register\Plugin\WorkflowType;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\Plugin\WorkflowTypeBase;

/**
 * Share Transaction Group workflow type.
 *
 * @WorkflowType(
 *   id = "workflow_share_transaction_group",
 *   label = @Translation("Share Transaction Group Workflow"),
 *   required_states = {
 *     "draft",
 *     "valid",
 *   }
 * )
 */
class ShareTransactionGroupWorkflowType extends WorkflowTypeBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'states' => [
        'draft' => [
          'label' => 'Draft',
          'weight' => 0,
        ],
        'valid' => [
          'label' => 'Valid',
          'weight' => 1,
        ],
      ],
      'transitions' => [
        'validate' => [
          'label' => 'Validate',
          'to' => 'valid',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
      ],
    ];
  }

}
