<?php

namespace Drupal\shareholder_register\Plugin\WorkflowType;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\Plugin\WorkflowTypeBase;

/**
 * Share workflow type.
 *
 * @WorkflowType(
 *   id = "workflow_share",
 *   label = @Translation("Share Workflow"),
 *   required_states = {
 *     "draft",
 *     "issued",
 *     "redeemed",
 *   }
 * )
 */
class ShareWorkflowType extends WorkflowTypeBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'states' => [
        'draft' => [
          'label' => 'Draft',
          'weight' => 0,
        ],
        'issued' => [
          'label' => 'Issued',
          'weight' => 1,
        ],
        'redeemed' => [
          'label' => 'Redeemed',
          'weight' => 1,
        ],
      ],
      'transitions' => [
        'issue' => [
          'label' => 'Issue',
          'to' => 'issued',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
        'redeem' => [
          'label' => 'Redeem',
          'to' => 'redeemed',
          'weight' => 0,
          'from' => [
            'issued',
          ],
        ],
      ],
    ];
  }

}
