<?php

namespace Drupal\shareholder_register\Plugin\WorkflowType;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\Plugin\WorkflowTypeBase;

/**
 * Shareholder workflow type.
 *
 * @WorkflowType(
 *   id = "workflow_shareholder",
 *   label = @Translation("Shareholder Workflow"),
 *   required_states = {
 *     "draft",
 *     "valid",
 *     "refused",
 *     "cancel",
 *   }
 * )
 */
class ShareholderWorkflowType extends WorkflowTypeBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'states' => [
        'draft' => [
          'label' => 'Draft',
          'weight' => 0,
        ],
        'valid' => [
          'label' => 'Valid',
          'weight' => 1,
        ],
        'refused' => [
          'label' => 'Refused',
          'weight' => 2,
        ],
        'cancel' => [
          'label' => 'Canceled',
          'weight' => 3,
        ],
      ],
      'transitions' => [
        'validate' => [
          'label' => 'Validate',
          'to' => 'valid',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
        'refuse' => [
          'label' => 'Refuse',
          'to' => 'refused',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
        'cancel' => [
          'label' => 'Cancel',
          'to' => 'cancel',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
      ],
    ];
  }

}
