<?php
/**
 * @file
 * Contains \Drupal\shareholder_register\Plugin\monitoring\SensorPlugin\ShareholderRegisterIntegritySensorPlugin.
 */

namespace Drupal\shareholder_register\Plugin\monitoring\SensorPlugin;

use Drupal\monitoring\Result\SensorResultInterface;
use Drupal\monitoring\SensorPlugin\SensorPluginBase;

/**
 * Monitors shareholder register module for data integrity.
 *
 * @SensorPlugin(
 *   id = "shareholder_register_integrity",
 *   label = @Translation("Shareholder Register Integrity"),
 *   description = @Translation("Monitors integrity of shareholder register data."),
 *   provider = "shareholder_register",
 *   addable = TRUE
 * )
 *
 */
class ShareholderRegisterIntegritySensorPlugin extends SensorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function runSensor(SensorResultInterface $result) {
    if (\Drupal::service('shareholder_register.drush')->integrityCheck()) {
      $result->setStatus($result::STATUS_OK);
    }
    else {
      $result->setStatus($result::STATUS_CRITICAL);
    }
  }
}
