<?php

namespace Drupal\shareholder_register\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Plugin\Field\FieldType\AddressFieldType;

/**
 * A handler to provide display for the share count.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("shareholder_register_view_address_field")
 */
class ShareholderRegisterViewAddressField  extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['property_name'] = ['default' => 'given_name'];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    $options = [];
    foreach (AddressFieldType::getDefinition() as $k => $d) {
      $options[$k] = $d['label'];
    }
    $form['property_name'] = [
      '#type' => 'select',
      '#title' => $this->t('Choose the property to display'),
      '#default_value' => $this->options['property_name'],
      '#options' => $options,
    ];
    parent::buildOptionsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $entity = $this->getEntity($values);
    return $entity->get('address')->{$this->options['property_name']};
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // This function exists to override parent query function.
    // Do nothing.
  }
}
