<?php

namespace Drupal\shareholder_register\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Markup;

use Drupal\shareholder_register\Plugin\Field\FieldType\AddressFieldType;

/**
 * A handler to provide display for the share count.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("shareholder_register_view_address_format")
 */
class ShareholderRegisterViewAddressFormat  extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $entity = $this->getEntity($values);
    $r = Markup::create(AddressFieldType::formatAddress($entity->get('address')));
    return $r;
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // This function exists to override parent query function.
    // Do nothing.
  }
}
