<?php

namespace Drupal\shareholder_register\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * A handler to provide display for the share count.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("shareholder_register_view_number_string")
 */
class ShareholderRegisterViewNumberString  extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function clickSort($order) {
    $this->ensureMyTable();
    $field = $this->query->addField(NULL, "(0 + {$this->tableAlias}.{$this->realField})", $this->realField . '_sort');
    $params = $this->options['group_type'] != 'group' ? ['function' => $this->options['group_type']] : [];
    $this->query->addOrderBy(NULL, NULL, $order, $field, $params);
  }

}
